//
//  Shaders.metal
//  ComputeShader
//
//  Created by Alex Hoppen on 26.07.19.
//  Copyright © 2019 Alex Hoppen. All rights reserved.
//

#include <metal_stdlib>
using namespace metal;

kernel void redTintTexture(texture2d<float, access::read> inTexture [[texture(0)]],
                           texture2d<float, access::write> outTexture [[texture(1)]],
                           uint2 gid [[thread_position_in_grid]]) {
    float4 color = inTexture.read(gid);
    
    color.x *= 2;
    if (color.x > 1) {
        color.x = 1;
    }
    outTexture.write(color, gid);
}
